<?php

$args = array(
	"background_color" => "",
	"background_image" => "",
	"item_padding" => "",
	"aligment" => "",
	"vertical_alignment" => "",
	"enable_hover_effect" => "",
	"image_link" => "",
	"image_link_text" => esc_html__("Find out more", 'moose'),
	"hover_image" => "",
	"animation_name" => "",
	"animation_delay" => "",
	"advanced_animations" => "no",
	"start_position" => "",
	"end_position" => "",
	"start_animation_style" => "",
	"end_animation_style" => "",
	"item_padding_1300_1600" => "",
	"item_padding_1000_1300" => "",
	"item_padding_768_1000" => "",
	"item_padding_600_768" => "",
	"item_padding_480_600" => "",
	"item_padding_480" => ""
);

$html = "";
$hover_set = '';
$eltd_elements_item_style = "";
$eltd_elements_item_inner_style = "";


extract(shortcode_atts($args, $atts));

$background_color = esc_attr($background_color);
$background_image = esc_attr($background_image);
$item_padding = esc_attr($item_padding);
$animation_delay = esc_attr($animation_delay);
$start_position = esc_attr($start_position);
$end_position = esc_attr($end_position);
$start_animation_style = esc_attr($start_animation_style);
$end_animation_style = esc_attr($end_animation_style);
$item_padding_1300_1600 = esc_attr($item_padding_1300_1600);
$item_padding_1000_1300 = esc_attr($item_padding_1000_1300);
$item_padding_768_1000 = esc_attr($item_padding_768_1000);
$item_padding_600_768 = esc_attr($item_padding_600_768);
$item_padding_480_600 = esc_attr($item_padding_480_600);
$item_padding_480 = esc_attr($item_padding_480);


$vertical_alignment_class = "vertical_alignment_middle";
if($vertical_alignment !== ""){
	$vertical_alignment_class = "vertical_alignment_" . $vertical_alignment;
}

if($background_color != "" || $animation_delay != "" || $background_image != ""){
	$eltd_elements_item_style .= " style='";
}

if($background_color != ""){
	$eltd_elements_item_style .= "background-color:" . $background_color . ";";
}

if($background_image != ""){
	if(is_numeric($background_image)) {
		$background_image_src = wp_get_attachment_url( $background_image );
	} else {
		$background_image_src = $background_image;
	}
	$eltd_elements_item_style .= "background-image: url(".$background_image_src.");";
}

if($animation_delay != ""){
	$eltd_elements_item_style .= 'transition-delay:' . $animation_delay .'ms;'. '-webkit-transition-delay:' . $animation_delay .'ms;' ;
}

if($background_color != "" || $animation_delay != "" || $background_image != ""){
	$eltd_elements_item_style .= "'";
}

$alignment_class = "";
if($aligment != ""){
	$eltd_elements_item_inner_style .= "text-align:" . $aligment . ";";
	$alignment_class = "horizontal_align_".$aligment;
}

if($item_padding != ""){
	$eltd_elements_item_inner_style .= "padding:" . $item_padding . ";";
}

if (($enable_hover_effect == 'yes') && ($hover_image != '') && ($image_link != '')) {
	$hover_set = 'animated_boxes';
}


$html .= "<div class='eltd_elements_item $vertical_alignment_class $alignment_class $animation_name $hover_set' data-animation='$advanced_animations'";

if ($advanced_animations == 'yes') {
	$html .= " data-".$start_position."='$start_animation_style' data-".$end_position."='$end_animation_style'";
}

$html .= $eltd_elements_item_style . "><div class='eltd_elements_item_inner'>";

$random_custom_class = "eltd_elements_inner_" . rand();

$html .= "<div class='eltd_elements_item_content " . $random_custom_class . "' style='". $eltd_elements_item_inner_style ."'>";
if($item_padding_1300_1600 !== "" || $item_padding_1000_1300 !== "" || $item_padding_768_1000 !== "" || $item_padding_600_768 !== "" || $item_padding_480_600 !== "" || $item_padding_480 !== ""){
	$html .= '<style type="text/css" data-type="eltd_elements-custom-padding" scoped>';

	if($item_padding_1300_1600){
		$html .= "@media only screen and (min-width: 1300px) and (max-width: 1600px) {";
		$html .= ".eltd_elements_holder .eltd_elements_item_content.".$random_custom_class."{";
		$html .= "padding:".$item_padding_1300_1600 . "!important";
		$html .= "}";
		$html .= "}";
	}
	if($item_padding_1000_1300){
		$html .= "@media only screen and (min-width: 1000px) and (max-width: 1300px) {";
		$html .= ".eltd_elements_holder .eltd_elements_item_content.".$random_custom_class."{";
		$html .= "padding:".$item_padding_1000_1300 . "!important";
		$html .= "}";
		$html .= "}";
	}
	if($item_padding_768_1000){
		$html .= "@media only screen and (min-width: 768px) and (max-width: 1000px) {";
		$html .= ".eltd_elements_holder .eltd_elements_item_content.".$random_custom_class."{";
		$html .= "padding:".$item_padding_768_1000 . "!important";
		$html .= "}";
		$html .= "}";
	}
	if($item_padding_600_768){
		$html .= "@media only screen and (min-width: 600px) and (max-width: 768px) {";
		$html .= ".eltd_elements_holder .eltd_elements_item_content.".$random_custom_class."{";
		$html .= "padding:".$item_padding_600_768 . "!important";
		$html .= "}";
		$html .= "}";
	}
	if($item_padding_480_600){
		$html .= "@media only screen and (min-width: 480px) and (max-width: 600px) {";
		$html .= ".eltd_elements_holder .eltd_elements_item_content.".$random_custom_class."{";
		$html .= "padding:".$item_padding_480_600 . "!important";
		$html .= "}";
		$html .= "}";
	}
	if($item_padding_480){
		$html .= "@media only screen and (max-width: 480px) {";
		$html .= ".eltd_elements_holder .eltd_elements_item_content.".$random_custom_class."{";
		$html .= "padding:".$item_padding_480 . "!important";
		$html .= "}";
		$html .= "}";
	}
	$html .= "</style>";
}
$html .= do_shortcode($content);
$html .= '</div></div>';

if ($enable_hover_effect != 'no') {

	if ($hover_image != '') {

		//var
		$image_src = '';

		$image_src = wp_get_attachment_url($hover_image);

		$html .= '<div class="animated_boxes_image" style="background: url('.esc_url($image_src).')"></div>';

	}

	if ($image_link != '') {

		$html .= '<div class="animated_boxes_shader">';
		$html .= do_shortcode('[no_button link="' . $image_link . '" text="' . $image_link_text . '" icon_pack="font_elegant" fe_icon="arrow_carrot-2right" button_hover_animation="rotate_icon" style="transparent"]');
		$html .= '</div>'; //close animated boxes shader
	
	}

}

$html .= '</div>';

echo moose_elated_get_module_part($html);

